<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' name='viewport' />
    
    <meta name="description" content="Improve">
    <title>Improve Canada</title>
    <link rel="stylesheet" href="css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="css/site.css">
    <link rel="stylesheet" href="css/keyboard/keyboard.css">
    <link rel="stylesheet" href="css/table.css">
    <link rel="stylesheet" href="js/sly/sly-vertical.css" />
    <link rel="stylesheet" href="js/sweet/sweetalert2.min.css" />
    <link rel="stylesheet" type="text/css" href="css/component.css" />
    <link rel="stylesheet" type="text/css" href="css/animations.css" />
    <!--<link rel="stylesheet" type="text/css" href="css/clock.css" />-->
    <link rel="stylesheet" type="text/css" media="screen" href="css/connect-the-dots.css" />
    <script src="js/lde-utils.min.js"></script>
    <?php
    header('Access-Control-Allow-Origin: *');
    ?>
    <style>
        body {
            overflow-x: auto;
            overflow-y: auto;
        }

        .marker-entry {
            position: absolute;
            line-height: 12px;
            padding: 1px;
        }

        .marker-entry-text {
            font-size: 9px;
            text-align: center;
            position: relative;
            height: 27px;
            width: 27px;
            border-radius: 1px;
            float: left;
            padding-top: 7px;
            color: red;
            font-weight: 700;
        }

        .marker-entry-text-head {
            font-size: 175%;
            color: red;
        }

        .marker-entry-pointer {
            color: red;
        }

        .marker-entry-pointer-top {
            position: absolute;
            bottom: 25px;
            left: 7px;
        }

        .marker-entry-pointer-btm {
            position: absolute;
            top: 36px;
            right: 8px;
        }

        .marker-entry-pointer-left {
            position: absolute;
            top: 10px;
            right: 30px;
        }

        .marker-entry-pointer-right {
            position: absolute;
            bottom: 5px;
            left: 32px;
        }

        .marker-avenue {
            position: absolute;
            line-height: 12px;
            padding: 1px;
        }

        .marker-avenue p {
            font-size: 9px;
            text-align: center;
            position: relative;
            float: left;
            font-weight: 700;
            color: green;
            white-space: nowrap;
            padding: 0 !important;
            margin: 0 !important;
        }

        .marker-court-yard {
            position: absolute;
            line-height: 12px;
            padding: 1px;
        }

        .marker-court-yard p {
            font-size: 9px;
            text-align: center;
            position: relative;
            float: left;
            font-weight: 700;
            color: #111111;
            white-space: nowrap;
            padding: 0 !important;
            margin: 0 !important;
        }

        .rotate-90 {
            /* Safari */
            -webkit-transform: rotate(-90deg);
            /* Firefox */
            -moz-transform: rotate(-90deg);
            /* IE */
            -ms-transform: rotate(-90deg);
            /* Opera */
            -o-transform: rotate(-90deg);
            /* Internet Explorer */
            filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);
        }

        .rotate-180 {
            /* Safari */
            -webkit-transform: rotate(-180deg);
            /* Firefox */
            -moz-transform: rotate(-180deg);
            /* IE */
            -ms-transform: rotate(-180deg);
            /* Opera */
            -o-transform: rotate(-180deg);
            /* Internet Explorer */
            filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=2);
        }

        .rotate-270 {
            /* Safari */
            -webkit-transform: rotate(-270deg);
            /* Firefox */
            -moz-transform: rotate(-270deg);
            /* IE */
            -ms-transform: rotate(-270deg);
            /* Opera */
            -o-transform: rotate(-270deg);
            /* Internet Explorer */
            filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1);
        }

        /* Ensure the container uses Flexbox */
        .row.flex-container {
            display: flex;
            flex-wrap: wrap;
            /* Allows items to wrap when they don't fit in a row */
            gap: 10px;
            /* Add spacing between elements */
            align-items: center;
            /* Vertically center items in the row */
            justify-content: space-between;
            /* Distribute items evenly with space between */
        }

        /* Flex items for businesses and units */
        .flex-item {
            flex: 1 1 calc(50% - 10px);
            /* Adjust width to 50%, minus spacing */
            box-sizing: border-box;
            /* Include padding and border in width calculation */
        }

        /* Ensure tables don't overflow */
        .flex-item table {
            width: 100%;
            /* Tables take full width of the flex item */
        }

        /* Responsive adjustments for smaller screens */
        @media (max-width: 768px) {
            .flex-item {
                flex: 1 1 100%;
                /* Take full width on small screens */
            }
        }

        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }

        .container {
            display: flex;
            flex-wrap: wrap;
            /* Allows items to wrap if needed */
        }

        .box {
            flex: 1 1 calc(50% - 20px);
            /* Take up 50% of container width minus gap */
            min-width: 200px;
            /* Ensures the divs won't shrink too small */
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        /* For very narrow screens, stack divs vertically */
        @media (max-width: 500px) {
            .box {
                flex: 1 1 100%;
            }
        }

        .toggle-btn {
            padding: 15px 30px;
            margin: 20px;
            font-size: 18px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .start-mode {
            background-color: #4CAF50;
            color: white;
        }

        .stop-mode {
            background-color: #f44336;
            color: white;
        }

        .status {
            margin-top: 20px;
            font-size: 18px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="box">
            <div class="pt-perspective backmap">
                <div class="row mapbox backmap">

                    <div style="text-align-last: center;">
                        <button class="toggle-btn start-mode" id="toggle-button">Click To Talk</button>
                        <p class="status" id="status-text">Click to start speaking</p>
                    </div>

                    <div class="col-md-12" id="mapouter">
                        <div id="mapcontainer" class="mapcontainer">
                            <img src="img/colored-map.png" />
                            <div id="canvas">
                                <?php
                                // Loop from 1 to 429
                                for ($i = 1; $i <= 401; $i++) {
                                    echo '<div onclick="show_path(' . $i . ')"  class="line" id="line-' . $i . '"></div>' . PHP_EOL;
                                }
                                ?>
                                <div id="washroom"></div>
                                
                                <div class="line" id="line-w"></div>
                                <!--entries-->
                                <!-- Avenues extra.push([735,192,0,10]);-->
                                <!--Streets-->
                                <!--entries-->
                                <div id="secondfloor" class="secondfloor">
                                    <img src="img/office-2nd<?php echo $kiosk_option->rotation; ?>.png" id="office2nd"
                                        class="img-responsive" />
                                    <img src="img/meeting-2nd.png" id="meeting2nd" class="img-responsive" />
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>
            </div>
        </div>

        <div class="box" style="margin-top: 200px; width: 50%" id="pt-main">
            <div class="container-fluid">
                <div class="row boxes block1">
                    <div class="col-md-4 nopadright nopadleft">
                        <div class="groupbox logo">
                            <video playsinline autoplay muted loop style="width: 100%;height: 100%;">
                                <source src="img/Comp 1.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-12 nopadleft nopadright">
                                <div class="groupbox searchbox">
                                    <div class="input-group add-on">
                                        <div id="input-container"><input class="form-control"
                                                placeholder="SEARCH BY NAME OR STORE #" name="srch-term" id="inter"
                                                type="text" /></div>
                                        <div class="input-group-btn">
                                            <button class="btn btn-default" type="submit"><i
                                                    class="glyphicon glyphicon-search"></i></button>
                                        </div>
                                    </div>
                                    <!--ccc-->
                                    <div class="row listing-box orangecolor block2">
                                        
                                        <div class="col-md-4 ">
                                            <div class="listing-caption-box">
                                                <div class="category" id="unit-btn">
                                                    <span class='btn btn-primary btn-unit'>UNITS</span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <!--ccc-->
                                </div>
                            </div>
                        </div><!--row-->
                    </div><!--col 8-->
                </div><!--block1-->
            </div><!--container-->

            <div class="pt-page pt-page-1 container-fluid">

                <div class="row block3">
                    <div class="col-md-12 nopadleft nopadright" style="margin-top: 88px;" id="store-cont">
                        <div id="basic_container" style="display:none"></div>
                        <div id="unit_container">
                            
                            <div class="frame listings" id="basic-unit">
                                <ul class="clearfix" id="unit_numbers" style="overflow-x: auto; overflow-y: auto;">
                                    <?php
                                $ci=1;
                                foreach($stores_unit as $unit){
                                    if($ci==1) {
                                ?>
                                    <li style="width: 100%" class="store"
                                        style="overflow-x: auto; overflow-y: auto;">
                                        <div class="row flex-container">
                                            <div class="col-md-12 flex-item">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            <th>Business</th>
                                                            <th>UNIT #</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php } ?>
                                                        <tr data-xid="<?php echo $unit->id; ?>">
                                                            <td><?php echo $unit->name; ?></td>
                                                            <td><?php echo $unit->units; ?></td>
                                                        </tr>
                                                        <?php if($ci%17==0){ $ci=0; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </li>
                                    <?php } $ci++;
                                }
                                if($ci!=1){ ?>
                                    </tbody>
                                    </table>
                            </div>
                        </div>
                        </li>
                        <?php } ?>
                        </ul>
                    </div>
                </div>
                <div id="list_container_category" style="display: none;">
                    
                    <div class="frame listings" id="basic-list-category">
                        <ul id="category_list" class="list_numbers">
                            <?php
                    $ci=1;
                    foreach($categories as $cat){
                      if($ci==1){?>
                            <li style="width: 100%" class="store">
                                <div class="row flex-container">
                                    <div class="col-md-12 flex-item">
                                        <table class="table">
                                            <tbody>
                                                <?php } ?>
                                                <tr data-xid="<?php echo $cat->name; ?>">
                                                    <td><?php echo $cat->name; ?></td>
                                                </tr>
                                                <?php if($ci%18==0){ $ci=0; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </li>
                            <?php } $ci++;
                    }
                    if($ci!=1){ ?>
                            </tbody>
                            </table>
                    </div>
                </div>
                </li>
                <?php }
                    ?>
                </ul>
            </div>
        </div>
    </div>

    <div id="list_container_store" style="display: none;">
        <i class="glyphicon glyphicon-triangle-left left-previous prevPage"></i>
        <i class="glyphicon glyphicon-triangle-right right-next nextPage"></i>
        <div class="frame listings" id="basic-list-store">

            <ul id="store_list" class="list_numbers">
                <?php
            $ci=1;
            foreach($stores_list as $list){
                if($ci==1) { ?>
                <li class="store">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table">
                                <tbody>
                                    <?php } ?>
                                    <tr data-xid="<?php echo $list->id; ?>">
                                        <td>#<?php echo $list->unit_number; ?> <?php echo $list->name; ?>
                                            <!--<span>#<?php echo $list->unit_number; ?> - <?php echo $list->extra_title; ?></span>-->
                                        </td>
                                    </tr>
                                    <?php if($ci%15==0){ $ci=0; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </li>
                <?php } $ci++;
              }
              if($ci!=1){ ?>
                </tbody>
                </table>
        </div>
    </div>
    </li>
    <?php }
    ?>
    </ul>
    </div>
    </div>

    <div id="list_container" style="display: none;">
        <i class="glyphicon glyphicon-triangle-left left-previous prevPage"></i>
        <i class="glyphicon glyphicon-triangle-right right-next nextPage"></i>
        <div class="frame listings" id="basic-list">
            <ul id="store_list_result" class="list_numbers">
            </ul>
        </div>
    </div>

    </div>
    </div>
    </div><!--container page 1-->
    <div class="pt-page pt-page-2 container-fluid">
        <div class="row store-details">
            <h2 id="details_name">Best Brand Appliances - Unit #45</h2>
            <div class="store-details-content">
                <div class="col-md-7" id="details_description">

                </div>
                <div class="col-md-5" id="details_contact">

                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div id="details_images">
                            <div class="listing-images" id="basic-images">
                                <ul class="clearfix" id="store-images">
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <i class="glyphicon glyphicon-remove-circle close_details"></i>
    </div>

    <div class="advertisement" style="display:none">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <img src="img/adds1.jpg" class="img-responsive" />
                </div>
            </div>
        </div>
    </div>
    </div>

    <div id="largemap" class="largemap"><img src="img/map-<?php echo $kiosk_option->rotation; ?>.jpg" class="img-responsive" />
        <div class="resize-small"><i class="glyphicon glyphicon-remove-circle"></i></div>
    </div>
    <div id="keycont"></div>

    </div>

    <div id="xdate"></div>
    <div id="xday"></div>

    <div class="weather time" id="wt">
        <div class="weather-cont">
            <div id="clock"></div>
        </div>
        <div class="weather">
            <!--<img src="img/weather.png" class="img-responsive"/>-->
            <div class="degree">
                <div id="weather"></div>
            </div>
        </div>
    </div>

    <div id="fsModal" class="modal animated bounceIn" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel" aria-hidden="true" style="z-index: 999999">

        <!-- dialog -->
        <div class="modal-dialog">

            <!-- content -->
            <div class="modal-content">

                <!-- header -->
                <div class="modal-header">
                    <h1 id="myModalLabel" class="modal-title">
                        <p class="title pull-left" style="width:80%">Modal title</p>
                        <i class="glyphicon glyphicon-remove-circle float-right pull-right" data-dismiss="modal"></i>
                    </h1>
                </div>
                <!-- header -->

                <!-- body -->
                <div class="modal-body">

                    <iframe src="" frameborder="0" id="web_iframe" style="width:100%; height:100%"></iframe>
                </div>
                <!-- body -->

                <!-- footer -->
                <div class="modal-footer">
                    <input type="button" class="btn btn-primary pull-left" value="Back" onclick="history.back()">
                    <input type="button" value="Forward" class='btn btn-primary pull-right'
                        onclick="history.forward()">
                </div>
                <!-- footer -->

            </div>
            <!-- content -->

        </div>
        <!-- dialog -->

    </div>
    <!-- modal -->
    <script src="js/modernizr.custom.js"></script>
    <script src="js/keyboard/jquery-latest.min.js"></script>
    <script src="js/keyboard/jquery.keyboard.js"></script>
    <script src="js/keyboard/jquery.mousewheel.js"></script>
    <script src="js/keyboard/jquery.keyboard.extension-typing.js"></script>
    <script src="js/keyboard/jquery.keyboard.extension-autocomplete.js"></script>
    <script src="js/keyboard/jquery.keyboard.extension-caret.js"></script>
    <script src="js/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="js/sly/sly.js" type="text/javascript"></script>
    <script src="js/sly/sly-plugin.js"></script>
    <script src="js/pagetransitions.js"></script>
    <script src="js/keyboard/keyboard.js"></script>
    <script src="js/jquery.simpleWeather.js"></script>
    <script src="js/mapper.js"></script>
    <!--<script src="js/moment.js"></script>
    <script src="js/clock.script.js"></script>-->
    <script src="js/sweet/sweetalert2.min.js"></script>
    
    
    <script>
        const button = document.getElementById('toggle-button');
        const statusText = document.getElementById('status-text');
        let isSpeaking = false; // Tracks speaking state
        let recognition; // For speech recognition
        let inactivityTimeout; // Timer for inactivity
        const INACTIVITY_LIMIT = 5000; // 5 seconds of inactivity
        let recognizedSpeech = ''; // Stores the recognized speech
        let speechText = '';
        let lastSpeechTime = null; // Tracks last detected speech time
    
        // Function to initialize speech recognition
        function initializeSpeechRecognition() {
            const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
            if (!SpeechRecognition) {
                alert("Speech Recognition API is not supported in your browser.");
                return null;
            }
            recognition = new SpeechRecognition();
            recognition.continuous = true; // Keep listening continuously
            recognition.interimResults = true; // Capture interim results for better speech detection
            recognition.lang = 'en-US'; // Set the language
            return recognition;
        }
    
        // Function to send a request to a given URL
        async function sendPostRequest(url, speechText) {
            try {
                const formdata = new FormData();
                formdata.append("speech", speechText);
    
                const requestOptions = {
                    method: "POST",
                    body: formdata,
                    redirect: "follow"
                };
    
                const response = await fetch(url, requestOptions);
                const result = await response.text();
                console.log("Response Data:", result);
    
                const jsonResponse = JSON.parse(result);
                if (jsonResponse && jsonResponse.output) {
                    $("#inter").val(jsonResponse.output);
                    show_path(jsonResponse.output);
                }
            } catch (error) {
                console.error(`Failed to send POST request: ${error}`);
            }
        }
    
        // Function to handle button toggle
        function toggleSpeaking() {
            if (!isSpeaking) {
                startSpeaking();
            } else {
                stopSpeaking(true); // Indicates manual stop
            }
        }
    
        // Start speaking: Start speech recognition and change button to "Stop"
        function startSpeaking() {
            if (!recognition) {
                recognition = initializeSpeechRecognition();
                if (!recognition) return;
            }
    
            isSpeaking = true;
            lastSpeechTime = null; // Reset the speech time
            clearTimeout(inactivityTimeout); // Clear any previous inactivity timers
            recognizedSpeech = ''; // Clear recognized speech for the new session
    
            button.classList.remove('start-mode');
            button.classList.add('stop-mode');
            button.textContent = 'Stop Speaking';
            statusText.textContent = 'Listening... Speak now.';
    
            // Start speech recognition
            recognition.start();
    
            // Handle speech recognition results
            recognition.onresult = (event) => {
                speechText = Array.from(event.results)
                    .map(result => result[0].transcript)
                    .join('');
                console.log("Interim/Final Speech11:", speechText);
    
                // Update last speech time
                lastSpeechTime = Date.now();
    
                // Append to recognized speech only if final result
                if (event.results[event.results.length - 1].isFinal) {
                    recognizedSpeech += speechText + ' ';
                }
    
                resetInactivityTimer();
            };
    
            recognition.onerror = (event) => {
                console.error("Speech recognition error:", event.error);
            };
    
            // Monitor inactivity
            monitorInactivity();
        }
    
        // Stop speaking: Stop speech recognition and change button to "Start"
        function stopSpeaking(isManualStop = false) {
            if (!isSpeaking) return; // Prevent double stop
    
            isSpeaking = false;
            button.classList.remove('stop-mode');
            button.classList.add('start-mode');
            button.textContent = 'Start Speaking';
            statusText.textContent = 'Click to start speaking';
    
            // Stop recognition
            if (recognition) recognition.stop();
    
            // Clear inactivity timer
            clearTimeout(inactivityTimeout);
    
            // Send speech text immediately if it's a manual stop or speech is available
            if (isManualStop || recognizedSpeech) {
                console.log('Processing speech immediately after stop.');
                setTimeout(() => {
                    console.log(recognizedSpeech.trim());
                    sendPostRequest('https://www.vortext.ca/processKioskInquiry.cfm', recognizedSpeech.trim());
                    recognizedSpeech = ''; // Clear recognized speech
                }, 1000);
            }

            // Always clear recognizedSpeech after attempting to send
            // recognizedSpeech = '';

            // Reset lastSpeechTime
            lastSpeechTime = null;
        }
    
        // Reset the inactivity timer
        function resetInactivityTimer() {
            clearTimeout(inactivityTimeout);
            inactivityTimeout = setTimeout(() => {
                const now = Date.now();
                if (lastSpeechTime && now - lastSpeechTime > INACTIVITY_LIMIT) {
                    console.log('No speech detected. Stopping automatically.');
                    stopSpeaking(false); // Indicates automatic stop
                }
            }, INACTIVITY_LIMIT);
        }
    
        // Monitor user inactivity
        function monitorInactivity() {
            setInterval(() => {
                const now = Date.now();
                if (isSpeaking && lastSpeechTime && now - lastSpeechTime > INACTIVITY_LIMIT) {
                    console.log('Detected user stopped speaking due to inactivity.');
                    stopSpeaking(false); // Automatically stop on inactivity
                }
            }, 1000);
        }
    
        // Event listener for button click
        button.addEventListener('click', toggleSpeaking);
    </script>
    

    
    <script type="text/javascript">
        document.addEventListener('contextmenu', event => event.preventDefault());

        var coords = storeblock;
        var ptstore = 1;
        var rotate = 0;
        var kiosk_pos = 1;
        <?php if ($kiosk_option) { ?>
        rotate = <?php echo $kiosk_option->rotation; ?> || 0; //0,90,180,270/
        kiosk_pos = <?php echo $kiosk_option->pos; ?> || 1;
        <?php } ?>
        var $frame = null;
        var $cframe = null;
        var $uframe = null;
        var $lframe = null;
        var $lcframe = null;
        var $lsframe = null;
        var trans = 6;
        var trans_cnt = 0;
        var activebox = 1;
        var selected_store = false;

        $(document).ready(function() {
            $.simpleWeather({
                location: 'Vaughan, ON L4K 1Z8',
                woeid: '',
                unit: 'c',
                success: function(weather) {
                    //html = weather.temp+'&deg;'+weather.units.temp;
                    html = '<i class="icon-' + weather.code + '"></i> ';
                    $("#weather").html(html);
                    setTimeout(function() {
                        $('.degree').css({
                            'display': "block"
                        });
                    }, 1000);
                    setTimeout(function() {
                        $("#weather").html(html + weather.temp + '&deg;' + weather.units.temp +
                            '');
                    }, 1200);
                    setTimeout(function() {
                        $('#clock').css({
                            'display': "block"
                        });
                    }, 1200);
                },
                error: function(error) {
                    //$("#weather").html('<p>'+error+'</p>');
                    setTimeout(function() {
                        $('#clock').css({
                            'display': "block"
                        });
                    }, 1200);
                }
            });

            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth(); //January is 0!
            var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sept", "Oct", "Nov", "Dec"
            ];
            var d = today.getDay();
            var dayNames = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }

            var today = monthNames[mm] + ' ' + dd + ', ' + yyyy;

            $('#xdate').html(today);
            $('#xday').html(dayNames[d]);
        });

        startTime();

        $("#categories").on("click", "li div.category-li", function() {
            category_store($(this).attr("data-xid"));
        });
        $("#unit_numbers").on("click", "table tbody tr", function() {
            store_details($(this).attr("data-xid"));
        });
        $("#category_list").on("click", "table tbody tr", function() {
            category_store($(this).attr("data-xid"));
        });
        $("#store_list").on("click", "table tbody tr", function() {
            store_details($(this).attr("data-xid"));
        });
        $(".close_details").on("click", function() {
            $('.store-details-content')
                .closest('.pt-page')
                .css({
                    'visibility': 'hidden',
                });
            trans = 3; //randomInt();
            if (!PageTransitions.nextPage(trans)) {
                PageTransitions.nextPage(9);
                trans = 5;
            }
        });
        $("#category-btn").click(function() {
            hide_details();
            displayNone();
            InputKeyboard(1);
            $('#category_container').css('display', "block");
            $("#category-btn span").addClass("active");
            if (!$cframe)
                showcategory();
            activebox = 1;
            $("#store-text span").text("LIST VIEW");
            document.getElementById("selected_category").innerHTML = '';
            $('#store-text').css('display', "block");
        });
        $("#store-text").click(function() {
            if (activebox == 2 && $("#store-text span").text() == "IMAGE VIEW") {
                displayNone(true);
                $('#basic_container').css('display', "block");
                $("#store-text span").text("LIST VIEW");
                if (!$lframe)
                    showList();
                hide_details();
            } else if (activebox == 2 && $("#store-text span").text() == "LIST VIEW") {
                displayNone(true);
                $('#list_container').css('display', "block");
                $("#store-text span").text("IMAGE VIEW");
                if (!$lframe)
                    showList();
                hide_details();
            } else {
                displayNone(true);
                if (activebox == 1) {
                    $('#list_container_category').css('display', "block");
                    if (!$lcframe)
                        showcategorylist();
                    activebox = 1;
                } else if (activebox == 2) {
                    $('#list_container').css('display', "block");
                    if (!$lframe)
                        showList();
                    activebox = 2;
                } else if (activebox == 3) {
                    $('#list_container_store').css('display', "block");
                    if (!$lsframe)
                        showstorelist();
                    activebox = 3;
                }
                $("#store-text span").text("LIST VIEW");
                hide_details();
            }
            $("#store-text span").addClass("active");
        });
        $("#store-btn").click(function() {
            hide_details();
            displayNone();
            InputKeyboard(2);
            $('#basic_container').css('display', "block");
            $("#store-btn span").addClass("active");
            activebox = 2;
            $('#store-text').css('display', "block");
        });
        $("#unit-btn").click(function() {
            alert("here");
            hide_details();
            displayNone();
            InputKeyboard(3);
            $('#unit_container').css('display', "block");
            $("#unit-btn span").addClass("active");
            // document.getElementById("selected_category").innerHTML = '';
            if (!$uframe)
                showUnit();
            activebox = 3;
            $("#store-text span").text("LIST VIEW");
            $('#store-text').css('display', "none");
        });
        $(".food-court").click(function() {
            clearpath();
            // $('.backmap').css({ 'background-image': "url(../img/bg-back.png)" });
            // $('#canvas').css({ 'background': "rgba(0,0,0,0.4)" });
            $('.extra-ico div').css({
                'opacity': "0.4"
            });
            $('.extra-ico .foodcourt-ico').addClass('foodcourt-ico-active');
            $('.highlighted').remove();
            targets = [0];
            targets[1] = [750, 200];
            //highlightExtra(targets,'fc');
        });
        $(".office").click(function() {
            clearpath();
            $('.highlighted').remove();
            $('#office2nd').css('display', "block");
            $('#meeting2nd').css('display', "none");
            prepare_path_elevator(true, kiosk_pos);
            // $('.backmap').css({ 'background-image': "url(../img/bg-back.png)" });
            // $('#canvas').css({ 'background': "rgba(0,0,0,0.4)" });
            $('.extra-ico div').css({
                'opacity': "0.4"
            });
        });
        $(".business").click(function() {
            clearpath();
            $('.highlighted').remove();
            $('#office2nd').css('display', "none");
            $('#meeting2nd').css('display', "block");
            prepare_path_elevator(false, kiosk_pos);
            // $('.backmap').css({ 'background-image': "url(../img/bg-back.png)" });
            // $('#canvas').css({ 'background': "rgba(0,0,0,0.4)" });
            $('.extra-ico div').css({
                'opacity': "0.4"
            });
        });
        $(".security").click(function() {
            clearpath();
            // $('.backmap').css({ 'background-image': "url(../img/bg-back.png)" });
            // $('#canvas').css({ 'background': "rgba(0,0,0,0.4)" });
            $('.extra-ico .washroom-ico').css({
                'opacity': "0.4"
            });
            $('.extra-ico .security-ico').addClass('active');
            $('.highlighted').remove();
            targets = [0];
            targets[1] = [478, 200];
            //highlightExtra(targets,'sc');
        });
        $(".information").click(function() {
            clearpath();
            // $('.backmap').css({ 'background-image': "url(../img/bg-back.png)" });
            // $('#canvas').css({ 'background': "rgba(0,0,0,0.4)" });
            $('.extra-ico div').css({
                'opacity': "0.4"
            });
            $('.highlighted').remove();
            $('div.kiosk_cont').addClass('active');
        });
        $(".fullscreen").click(function() {
            $('.largemap').css('display', "block");
        });
        $(".resize-small").click(function() {
            $('.largemap').css('display', "none");
        });

        showcategory();
        keyboard_all_keys();
        var timeout;
        document.onmousemove = function() {
            clearTimeout(timeout);
            timeout = setTimeout(function() {
                // location.reload(); /*/resetAll();*show_adds()*/
            }, 30000);
        }

        function InputKeyboard(a_activebox) {
            if (activebox != a_activebox) {
                document.getElementById("input-container").innerHTML =
                    '<input class="form-control" placeholder="SEARCH BY NAME OR UNIT #" name="srch-term" id="inter" type="text"/>';
                //if(a_activebox==1 || a_activebox==2)
                keyboard_all_keys();
                //else
                //keyboard_num_keys();
            }
            //hide_adds();
        }

        function hide_details(args) {
            if ($(".pt-page-2").hasClass("pt-page-current")) {
                trans = 1; //randomInt();
                if (!PageTransitions.nextPage(trans)) {
                    PageTransitions.nextPage(6);
                    trans = 6;
                }
            }
        }
        //mapper
        $(document).ready(function() {
            for (i = 1; i < coords.length; i++) {
                css = {
                    left: coords[i][0], //left: coords[i][0]-6,
                    top: coords[i][1], //top: coords[i][1]-17,
                    zIndex: coords.length -
                        i //to ensure lower numbers are on top of higher ones in case of overlap
                }
                class_active = '';
                // if (i < 410) {
                //     div = $('<div id="store_container_' + i + '" order_value="' + i + '" class="blockm_container' +
                //         class_active + '"><div class="spinner"></div></div>').css(css); //s'+(i+1)+'
                // } else {
                div = $('<div onclick="click_details(' + i + ')"id="store_container_' + i + '" order_value="' +
                    i + '" class="blockm_container' + class_active + '"><div class="blockm"><span>' + i +
                    '</span></div><div class="blockm_number"></div></div>').css(css); //s'+(i+1)+'
                // }
                $('#canvas').append(div);
            }
            var marker_txt = '';
            for (i = 1; i < kiosk.length; i++) {
                css = {
                    left: kiosk[i][0], //left: kiosk[i][0]-6,
                    top: kiosk[i][1], //top: kiosk[i][1]-17,
                }
                marker_txt = class_active = '';
                if (i == kiosk_pos) {
                    marker_txt = '<i class="glyphicon glyphicon-map-marker bounce' + rotate + '"></i>';
                    class_active = 'kactive';
                }
                div = $('<div id="kiosk_container_' + i + '" order_value="' + i +
                    '" class="blockm_container kiosk_cont ' + class_active +
                    '"><div class="blockm kiosk"><i class="glyphicon glyphicon-info-sign r' + rotate +
                    '"></i>' + marker_txt + '</div><div class="blockm_number"></div></div>').css(css); //s'+(i+1)+'
                $('#canvas').append(div);
            }
            for (i = 1; i < pathway.length; i++) {
                css = {
                    left: pathway[i][0], //left: pathway[i][0]-6,
                    top: pathway[i][1], //top: pathway[i][1]-17,
                    zIndex: pathway.length -
                        i //to ensure lower numbers are on top of higher ones in case of overlap
                }
                class_active = '';
                div = $('<div id="pathway_container_' + i + '" order_value="' + i + '" class="blockm_container' +
                    class_active +
                    '"><div class="blockm pathway"></div><div class="blockm_number pathnumbers">' + i +
                    '</div></div>').css(css); //s'+(i+1)+'
                $('#canvas').append(div);
            }
            for (i = 1; i < corners.length; i++) {
                css = {
                    left: corners[i][0], //left: corners[i][0]-6,
                    top: corners[i][1], //top: corners[i][1]-17,
                    zIndex: corners.length -
                        i //to ensure lower numbers are on top of higher ones in case of overlap
                }
                class_active = '';
                div = $('<div id="corners_' + corners[i][2] + '_' + corners[i][3] + '" data-index="' + i +
                    '" order_value="' + i + '" class="blockm_container' + class_active +
                    '"><div class="blockm corners"></div><div class="blockm_number pathnumbers">' + i +
                    '</div></div>').css(css); //s'+(i+1)+'
                $('#canvas').append(div);
            }
            for (i = 0; i < extra.length; i++) {
                css = {
                    left: extra[i][0], //left: corners[i][0]-6,
                    top: extra[i][1], //top: corners[i][1]-17,
                    zIndex: extra.length -
                        i //to ensure lower numbers are on top of higher ones in case of overlap
                }
                class_active = '';
                div = $('<div id="extra_' + i + '" data-index="' + i + '" order_value="' + i +
                    '" class="blockm_container' + class_active +
                    '"><div class="blockm extra"></div><div class="blockm_number"></div></div>').css(
                    css); //s'+(i+1)+'
                $('#canvas').append(div);
            }

            var top = 0
            if (rotate != 0 && rotate != 180) {
                top = -10;
            } //27
            setTimeout(function() {
                if (rotate != 0) {
                    var tx_r = rotate;
                    if (rotate == 90) tx_r = 270;
                    else if (rotate == 270) tx_r = 90;
                    $('#mapcontainer').attr("style", "transform: rotate(" + rotate +
                        "deg);transition-duration: 0s;margin-top:" + top + "px;");
                    $('.blockm span').attr("style", "transform: rotate(" + tx_r +
                        "deg);transition-duration: 0s;display:block;");
                    $('.kiosk i').attr("style", "transform: rotate(" + tx_r +
                        "deg);transition-duration: 0s;display:block;");
                    $('.extra-ico div').css({
                        'transform': "rotate(" + tx_r + "deg)"
                    })
                    //$('.largemap').css({ 'transform': "rotate("+rotate+"deg)" });
                    $('.surrounding-icons div').css({
                        'transform': "rotate(" + tx_r + "deg)"
                    });
                    if (rotate == 90) {
                        //$('.fullscreen').css({ 'bottom': "51px",'right': "35px" });
                        //$('.resize-small').css({ 'top': "10px",'right': "10px" });
                        $('#mapcontainer').attr("style", "transform: rotate(" + rotate +
                            "deg);transition-duration: 0s;margin-top:" + top + "px;");
                    } else if (rotate == 180) {
                        //$('.fullscreen').css({ 'bottom': "92px",'right': "33px" });
                        $('#marker-avenues div').css({
                            'transform': "rotate(90deg)"
                        })
                        $('.marker-streets div').css({
                            'transform': "rotate(180deg)"
                        })
                        $('#marker-entries .marker-entry-text').css({
                            'transform': "rotate(180deg)",
                            'top': '13px'
                        })
                        //$('.resize-small').css({ 'top': "10px",'left': "10px" });
                    } else if (rotate == 270) {
                        //$('.fullscreen').css({ 'bottom': "52px",'right': "53px" });
                        $('.rotate-90').css({
                            'transform': "rotate(90deg)"
                        })
                        //$('.resize-small').css({ 'bottom': "10px",'left': "10px" });
                    }
                }
                //$('.fullscreen').css({ 'display':'block' });
                $('.kiosk').attr("style", "display:block;");
                $('.mapcontainer img').attr("style", "display:block;");
                $('#canvas').attr("style", "display:block;");
                var bottom = 0;
                if (rotate != 0 && rotate != 180) {
                    $('#mapouter').attr("style", "height:981px;"); //1025px
                    $('.buttons').attr("style", "margin-top:21px;display:block;"); //-21
                    bottom = 837 - 170;
                } else {
                    bottom = $('#mapcontainer').position().top + $('#mapcontainer').outerHeight(true) - 170;
                    $('.buttons').attr("style", "display:block;");
                }
                $('#keycont').attr("style", "top:" + ($('.block1').position().top + $('.block1')
                        .outerHeight(true)) +
                    "px;position:absolute;width:100%; right:6px; z-index:999;");
                $('.pt-page-2').attr("style", "top:" + ($('.block3').position().top) +
                    "px;min-height:1030px");

                $('.fullscreen').attr("style", "visibility:visible;");
                $('.block1').attr("style", "visibility:visible;");
                $('.block3').attr("style", "visibility:visible;");

            }, 1000);
        });

        $(document).on('click', '.open_iframe', function() {

            var iframe_url = $(this).text();
            var title = $(this).data('xtitlex');
            console.log(title);

            $('#fsModal').find('.title').text(title);
            $('#fsModal').find('iframe').attr('src', iframe_url);
            $('#fsModal').modal('show');


        });

        $('#fsModal').on('shown.bs.modal', function() { //correct here use 'shown.bs.modal' event which comes in bootstrap3
            // $(this).find('iframe').attr('src',iframe_url);
        });

        $('#fsModal').on('hidden.bs.modal', function() {
            $(this).find('iframe').attr('src', '');
        })

        BASE_TKO = '<?php echo csrf_token(); ?>';
    </script>
</body>

</html>
