<?php

namespace App\Http\Controllers\User;

use Illuminate\Support\Facades\Input;
use Session;
use Auth;
use App\User;
use App\Http\Controllers\Controller;

class Authuser extends Controller {
	
	public function doAuth()
	{
		$errormsg=null;
		if(strlen(Input::get('email'))<5)
			$errormsg.="Username must be More than 4 Characters.<br/>";
		if(count(explode(' ', Input::get('email'))) > 1)
			$errormsg="Username must not contain White Space.<br/>";
		if($errormsg){
			Session::flash('failed', $errormsg);
			return Redirect::to('login');
		}else{
			Session::regenerate();
			if (Auth::attempt(['email' => Input::get('email'), 'password' => Input::get('password')])){
				if(Auth::User()->status==1){
						return redirect('user');
					}else{
						Session::flush();
						Session::flash('failed', 'User Login Failed2');
						return redirect('login');
					}
				}
			}
			Session::flush();
			Session::flash('failed', 'User Login Failed');
			return redirect('login');
	}
}

