<?php

namespace App\Http\Controllers\Canada;
use App\Models\Cms;
use App\Models\Reservations_Model;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;

class Store extends Controller {

    public function getsearch()
    {
        $searchString=escape(\Input::get('srch_str'));
        $like="";
        $rel_like="";
        $array=array();
        if(strlen($searchString)>0) {
            $str=explode(" ",$searchString);
            for($i=0;$i<count($str);$i++){
                if($i>0){
                    $like.=" or ";
                    $rel_like.=" + ";
                }
                $rel_like.="(match(a.name) against ('$str[$i]')) + (match(b.name) against ('$str[$i]')) + (a.name LIKE '%$str[$i]%') + (b.name LIKE '%$str[$i]%') ";
                $like.="(match(a.name) against ('$str[$i]')) or (match(b.name) against ('$str[$i]')) or (a.name LIKE '%$str[$i]%') or (b.name LIKE '%$str[$i]%') ";
            }
            $rel_like= ",($rel_like) as rel ";
            $like = " ($like)";
            
            $stores=\DB::select("Select a.id,a.logo,a.name,a.extra_title,a.description,a.extra_description,c.image,d.unit_number,group_concat(Distinct d.unit_number SEPARATOR ', ') as units$rel_like from kiosk_vendors a
                left join kiosk_vendor_keywords b on b.vendor_id=a.id   
                left join (select vendor_id,image from kiosk_vendor_images where main=1 group by vendor_id) c on c.vendor_id=a.id
                left join kiosk_vendor_units d on d.vendor_id=a.id
                where $like group by a.id order by rel desc ");
            $array=array("jStores"=>$stores);
        }
        echo json_encode($array,true);
    }
    
    public function getdetails()
    { 
        $array=array();
        $vendor=escape(\Input::get('vendor'));
        $unitx=escape(\Input::get('unit'));

        if($unitx){
            $unit_count =\DB::select(\DB::raw("select count(vendor_id) as c from kiosk_vendor_units where unit_number = '$unitx'"));
            $unit_count = $unit_count[0]->c;

            if($unit_count > 1) {
                $unit=\DB::table("kiosk_vendor_units")
                    ->where("unit_number",$unitx)
                    ->get(array("vendor_id"));     

                $array = [];
                foreach($unit as $u){
                    if($u->vendor_id){
                        $store=Cms::table("kiosk_vendors a")
                            ->leftJoin("kiosk_vendor_units as b","b.vendor_id","a.id")
                            ->where("a.id",$u->vendor_id)
                            ->groupBy("a.id")
                            ->first("a.id,a.name,a.logo,a.extra_title,a.description,a.extra_description,a.email,a.website_url,a.phone,b.unit_number");
                        if($store){
                            if(!$unitx)$unitx=$store->unit_number;
                                    $images=Cms::table("kiosk_vendor_images")
                                        ->where("vendor_id",$u->vendor_id)
                            ->limit(9)
                                        ->get("image");
                            $units=Cms::table("kiosk_vendor_units")
                                        ->where("vendor_id",$u->vendor_id)
                            ->groupBy("unit_number")
                                        ->get("unit_number");
                            $categories=Cms::table("kiosk_vendor_categories")
                                        ->where("vendor_id",$u->vendor_id)
                            ->orderBy("name","asc")
                            ->groupBy("name")
                            ->get("name");
                                    $array[]=array("jStore"=>$store,"jImages"=>$images,"jUnits"=>$units,"jUnit"=>$unitx,"jCategories"=>$categories);
                        }
                    }
                }
            } else {
                $unit=Cms::table("kiosk_vendor_units")
                    ->where("unit_number",$unitx)
                    ->first("vendor_id");      
            
                if($unit)$vendor=$unit->vendor_id;
                else{ $unitx=0; }

                if($vendor){
                    $store=Cms::table("kiosk_vendors a")
                        ->leftJoin("kiosk_vendor_units as b","b.vendor_id","a.id")
                        ->where("a.id",$vendor)
                        ->groupBy("a.id")
                        ->first("a.id,a.name,a.logo,a.extra_title,a.description,a.extra_description,a.email,a.website_url,a.phone,b.unit_number");

                    if($store){
                        if(!$unitx)$unitx=$store->unit_number;
                                $images=Cms::table("kiosk_vendor_images")
                                    ->where("vendor_id",$vendor)
                        ->limit(9)
                                    ->get("image");
                        $units=Cms::table("kiosk_vendor_units")
                                    ->where("vendor_id",$vendor)
                        ->groupBy("unit_number")
                                    ->get("unit_number");
                        $categories=Cms::table("kiosk_vendor_categories")
                                    ->where("vendor_id",$vendor)
                        ->orderBy("name","asc")
                        ->groupBy("name")
                        ->get("name");
                        $array=array("jStore"=>$store,"jImages"=>$images,"jUnits"=>$units,"jUnit"=>$unitx,"jCategories"=>$categories);

                        }
                }
                Log::info(["data2" => json_encode($array,true)]);
                echo json_encode($array,true);
            }
        } else {
            if($vendor) {
                $store=Cms::table("kiosk_vendors a")
                    ->leftJoin("kiosk_vendor_units as b","b.vendor_id","a.id")
                    ->where("a.id",$vendor)
                    ->groupBy("a.id")
                    ->first("a.id,a.name,a.logo,a.extra_title,a.description,a.extra_description,a.email,a.website_url,a.phone,b.unit_number");
                if($store){
                    if(!$unitx)$unitx=$store->unit_number;
                            $images=Cms::table("kiosk_vendor_images")
                                ->where("vendor_id",$vendor)
                    ->limit(9)
                                ->get("image");
                    $units=Cms::table("kiosk_vendor_units")
                                ->where("vendor_id",$vendor)
                    ->groupBy("unit_number")
                                ->get("unit_number");
                    $categories=Cms::table("kiosk_vendor_categories")
                                ->where("vendor_id",$vendor)
                    ->orderBy("name","asc")
                    ->groupBy("name")
                    ->get("name");
                            $array[]=array("jStore"=>$store,"jImages"=>$images,"jUnits"=>$units,"jUnit"=>$unitx,"jCategories"=>$categories);
                }
            }
            Log::info(["data3" => json_encode($array,true)]);
            echo json_encode($array,true);
        }
    }
    
    public function getcategorystores(){
            $array=array();
            $category=escape(\Input::get('category'));
            $fv="0";
            $filter=\DB::select('select GROUP_CONCAT(distinct(vendor_id)) as ids from kiosk_vendor_categories where name="'.$category.'" ');
            if($filter){
                $fv=$filter[0]->ids;
                if($fv){
                    $stores=\DB::select("Select a.id,a.name,a.logo,a.extra_title,a.description,a.extra_description,c.image,d.unit_number,group_concat(d.unit_number SEPARATOR ', ') as units from kiosk_vendors a
                                         left join (select vendor_id,image from kiosk_vendor_images where main=1 group by vendor_id) c on c.vendor_id=a.id
                                         left join kiosk_vendor_units d on d.vendor_id=a.id
                                         where id IN ($fv) group by a.id order by a.name asc "); //LPAD(d.unit_number, 4, 0)
                    $array=array("jStores"=>$stores,"jStores"=>$stores,"jCategory"=>$category);
                }
            }
            echo json_encode($array,true);
    }
}