<?php 
namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class VoiceSearchData implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels;

    public $data;

    /**
     * Create a new event instance.
     *
     * @param mixed $data
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return new Channel('voice-search-channel');
    }

    /**
     * Override the event name to broadcast with a custom name.
     *
     * @return string
     */
    public function broadcastAs()
    {
        return 'voice-search-channel-event';  // This name is what the frontend listens for
    }

    /**
     * Broadcast the event with custom data.
     *
     * @return array
     */
    public function broadcastWith()
    {
        Log::info('Broadcasting Data:', ['data' => $this->data]);
        return ['data' => $this->data]; // The data that will be sent to subscribers
    }
}
